<?php defined('BASEPATH') or exit('No direct script access allowed');
$CI = &get_instance();
$CI->load->model('workshop/workshop_model');
$repair_jobs = $CI->workshop_model->get_repair_job(false, false, ['project_id' => $project->id]);
?>
<div class="panel_s">
    <div class="panel-body">
        <h4 class="no-margin"><?php echo _l('wshop_repair_jobs'); ?></h4>
        <hr class="hr-panel-heading" />
        <div class="table-responsive">
            <table class="table dt-table" data-order-col="0" data-order-type="desc">
                <thead>
                    <th><?php echo _l('wshop_job_tracking_number'); ?></th>
                    <th><?php echo _l('wshop_repair_job_name'); ?></th>
                    <th><?php echo _l('wshop_device'); ?></th>
                    <th><?php echo _l('wshop_status'); ?></th>
                    <th><?php echo _l('wshop_appointment_date'); ?></th>
                </thead>
                <tbody>
                    <?php foreach($repair_jobs as $job){ ?>
                    <tr>
                        <td>
                            <a href="<?php echo admin_url('workshop/repair_job_detail/'.$job['id'].'?tab=detail'); ?>">
                                <?php echo $job['job_tracking_number']; ?>
                            </a>
                        </td>
                        <td><?php echo isset($job['name']) ? $job['name'] : '--'; ?></td>
                        <td>
                            <?php 
                            if($job['device_id'] != 0){
                                echo '<a href="' . admin_url('workshop/device_detail/' . $job['device_id']) . '">' . wshop_get_device_name($job['device_id']) . '</a>';
                            } else {
                                echo '--';
                            }
                            ?>
                        </td>
                        <td><?php echo render_repair_job_status_html($job['id'], '', $job['status']); ?></td>
                        <td><?php echo _dt($job['appointment_date']); ?></td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
